<?php
include("../includes/config.php");
include("../includes/db_connect.php");
include("../includes/upload.class.php");
include("../includes/functions.php");

$result = array();

$result["has_error"] = false;

if(	isset($_POST["fullname"]) 
	&& isset($_POST["email"])) 
{
		
	$user_id 		= $_SESSION["USER_ID"];
	$fullname 		= $_POST["fullname"]; 
	$email 			= $_POST["email"];
	
	if(TEST_MODE) {
		$error = "You can't save the profile in demo mode.";
		$result["has_error"] = true;
		$result["error"] = 998;
		$result["error_txt"] = $error;
	} else {
		
		
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			
			$error = "Your email is not valid.";
			$result["has_error"] = true;
			$result["error"] = 998;
			$result["error_txt"] = $error;
		} else if (empty($fullname)) {
			$error = "Your first name shouldn't be empty.";
			$result["has_error"] = true;
			$result["error"] = 998;
			$result["error_txt"] = $error;
		} else {	 
			
			// Create the occasion
			$stmt = $dbh->prepare("	UPDATE user 
									SET 
									fullname = :fullname,
									email = :email
									WHERE id = :id");
											
			$stmt->bindParam(':fullname', $fullname);
			$stmt->bindParam(':email', $email);
			$stmt->bindParam(':id', $user_id);
			$stmt->execute();
		
			// Return the final result
			$result["has_error"] = false;
		}
	
	}

		
} else {
	
	$result["error"] = 998;
	$result["has_error"] = true;
	$result["error_txt"] = "This user doesn't exist anymore.";
	
}

echo json_encode($result);
?>